/*
 * Decompiled with CFR 0.152.
 */
package com.su.slytherin.terraria.player;

import com.su.slytherin.terraria.TerrWriter;
import com.su.slytherin.terraria.player.Buff;
import com.su.slytherin.terraria.player.BuffList;
import com.su.slytherin.terraria.player.InvStack;
import com.su.slytherin.terraria.player.Item;
import com.su.slytherin.terraria.player.ItemInv;
import com.su.slytherin.terraria.player.ItemStack;
import com.su.slytherin.terraria.player.Player;
import com.su.slytherin.terraria.player.SpawnPoint;
import java.util.List;

public final class PlayerWriter {
    private final TerrWriter _writer = new TerrWriter();
    private final Player _player;

    public PlayerWriter(Player player) {
        this._player = player.copy();
    }

    public byte[] writePlayer() {
        this._writer.putInt(39);
        this.writeCharacter();
        this.writeColors();
        this.writeItems(this._player.getArmor(), 3, "Invalid Armor size");
        this.writeItems(this._player.getAccessories(), 5, "Invalid Accessory size");
        this.writeItems(this._player.getSocial(), 3, "Invalid Social size");
        this.writeStacks(this._player.getInventory(), 40, "Invalid Inventory size");
        this.writeStacks(this._player.getCoins(), 4, "Invalid Coin size");
        this.writeStacks(this._player.getAmmo(), 4, "Invalid Ammo size");
        this.writeStacks(this._player.getBank(), 20, "Invalid Bank size");
        this.writeStacks(this._player.getSafe(), 20, "Invalid Safe size");
        this.writeBuffs(this._player.getBuffs(), 10, "Invalid BuffList size");
        this.writeSpawns(this._player.getSpawnPoints(), 200, "Oversized spawn list");
        this._writer.putBoolean(this._player.isHotbarLocked());
        return this._writer.toByteArray();
    }

    private void writeCharacter() {
        this._writer.putString(this._player.getName());
        this._writer.putUnsigned(this._player.getDifficulty());
        this._writer.putInt(this._player.getHairstyle());
        this._writer.putBoolean(this._player.isMale());
        this._writer.putInt(this._player.getLife());
        this._writer.putInt(this._player.getLifeMax());
        this._writer.putInt(this._player.getMana());
        this._writer.putInt(this._player.getManaMax());
    }

    private void writeColors() {
        this._writer.putColor(this._player.getHairColor());
        this._writer.putColor(this._player.getSkinColor());
        this._writer.putColor(this._player.getEyeColor());
        this._writer.putColor(this._player.getOShirtColor());
        this._writer.putColor(this._player.getUShirtColor());
        this._writer.putColor(this._player.getPantsColor());
        this._writer.putColor(this._player.getShoeColor());
    }

    private void writeItems(ItemInv inventory, int size, String message) {
        assert (inventory.size() == size) : message;
        for (Item item : inventory) {
            this._writer.putInt(item.getItemId()).put(item.getPrefix());
        }
    }

    private void writeStacks(InvStack inventory, int size, String message) {
        assert (inventory.size() == size) : message;
        for (ItemStack stack : inventory) {
            this._writer.putInt(stack.getNetId()).putInt(stack.getCount());
            this._writer.put(stack.getPrefix());
        }
    }

    private void writeBuffs(BuffList buffs, int size, String message) {
        assert (buffs.size() == size) : message;
        for (Buff buff : buffs) {
            this._writer.putInt(buff.getType());
            this._writer.putInt(buff.getTime());
        }
    }

    private void writeSpawns(List<SpawnPoint> spawnPoints, int size, String message) {
        assert (spawnPoints.size() <= size) : message;
        for (SpawnPoint spawnPoint : spawnPoints) {
            this._writer.putInt(spawnPoint.getX()).putInt(spawnPoint.getY()).putInt(spawnPoint.getWorldID());
            this._writer.putString(spawnPoint.getWorldName());
        }
        if (spawnPoints.size() != 200) {
            this._writer.putInt(-1);
        }
    }
}

