/*
 * Decompiled with CFR 0.152.
 */
package com.su.slytherin.terraria.player;

import com.su.slytherin.terraria.TerrReader;
import com.su.slytherin.terraria.player.Buff;
import com.su.slytherin.terraria.player.BuffList;
import com.su.slytherin.terraria.player.Equipment;
import com.su.slytherin.terraria.player.InvStack;
import com.su.slytherin.terraria.player.Inventory;
import com.su.slytherin.terraria.player.Item;
import com.su.slytherin.terraria.player.ItemInv;
import com.su.slytherin.terraria.player.ItemStack;
import com.su.slytherin.terraria.player.Player;
import com.su.slytherin.terraria.player.PlayerIO;
import com.su.slytherin.terraria.player.SpawnPoint;
import java.util.ArrayList;
import java.util.List;

public final class PlayerReader {
    private final TerrReader _readBuffer;
    private final int _version;

    protected PlayerReader(TerrReader readBuffer) {
        this._readBuffer = readBuffer;
        this._version = readBuffer.getInt();
        PlayerReader.checkVersion(this._version);
    }

    protected Player readPlayer() {
        Player player = Player.create();
        player.setName(this._readBuffer.getString());
        this.readDifficulty(player);
        player.setHairstyle(this._readBuffer.getInt());
        this.readGender(player);
        this.readLifeMana(player);
        this.readColors(player);
        player.setArmor(this.readItems(3));
        player.setAccessories(this.readItems(5));
        if (this._version >= 6) {
            player.setSocial(this.readItems(3));
        }
        player.setInventory(this.readStacks(40));
        player.setCoins(this.readStacks(4));
        if (this._version >= 15) {
            player.setAmmo(this.readStacks(4));
        }
        player.setBank(this.readStacks(20));
        if (this._version >= 20) {
            player.setSafe(this.readStacks(20));
        }
        if (this._version >= 11) {
            player.setBuffs(this.readBuffs(10));
        }
        player.setSpawnPoints(this.readSpawnPoints());
        if (this._version >= 16) {
            player.setHotbarLocked(this._readBuffer.getBoolean());
        }
        boolean tests = false;
        if (!$assertionsDisabled) {
            tests = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (tests) {
            TerrReader two = this._readBuffer.duplicate();
            while (two.position() < two.capacity()) {
                assert (two.get() == 0) : "Unread bytes weren't 0";
            }
        }
        return player;
    }

    private static void checkVersion(int version) {
        if (!PlayerIO.KNOWN_VERSIONS.contains(version)) {
            String s1 = "Warning: Version number %d is unknown";
            if (version > 39) {
                System.err.printf("Warning: Version number %d is unknown and above known max! Severe failure is assured!\n", version);
            } else if (version < 0) {
                System.err.printf("Warning: Version number %d is unknown and negative! Severe failure is assured!\n", version);
            } else if (version < 39) {
                System.err.printf("Warning: Version number %d is unknown, but below known max. Severe failure is possible.\n", version);
            }
        }
    }

    private void readLifeMana(Player player) {
        player.setLife(this._readBuffer.getInt());
        player.setLifeMax(this._readBuffer.getInt());
        player.setMana(this._readBuffer.getInt());
        player.setManaMax(this._readBuffer.getInt());
    }

    private void readDifficulty(Player player) {
        if (this._version >= 10) {
            if (this._version >= 17) {
                player.setDifficulty(this._readBuffer.getUnsigned());
            } else if (this._readBuffer.getBoolean()) {
                player.setDifficulty(2);
            }
        }
    }

    private void readGender(Player player) {
        if (this._version >= 18) {
            player.setMale(this._readBuffer.getBoolean());
        } else {
            boolean male = true;
            int hair = player.getHairstyle();
            if (hair == 5 || hair == 6 || hair == 9 || hair == 11) {
                male = false;
            }
            player.setMale(male);
        }
    }

    private void readColors(Player player) {
        player.setHairColor(this._readBuffer.getColor());
        player.setSkinColor(this._readBuffer.getColor());
        player.setEyeColor(this._readBuffer.getColor());
        player.setOShirtColor(this._readBuffer.getColor());
        player.setUShirtColor(this._readBuffer.getColor());
        player.setPantsColor(this._readBuffer.getColor());
        player.setShoeColor(this._readBuffer.getColor());
    }

    private ItemInv readItems(int size) {
        ItemInv items = Equipment.create(size);
        assert (size <= items.size()) : "Bad Equipment size";
        int position = 0;
        while (position < size) {
            String name;
            char prefix;
            if (this._version >= 39) {
                int itemId = this._readBuffer.getInt();
                prefix = this._readBuffer.getUnsigned();
                items.setItem(position, Item.of(itemId, (int)prefix));
            } else if (this._version >= 36) {
                name = this._readBuffer.getString();
                prefix = this._readBuffer.getUnsigned();
                items.setItem(position, Item.of(name, (int)prefix));
            } else {
                name = this._readBuffer.getString();
                prefix = '\u0000';
                items.setItem(position, Item.of(name, (int)prefix));
            }
            ++position;
        }
        return items;
    }

    private InvStack readStacks(int size) {
        InvStack invStack = Inventory.create(size);
        assert (size <= invStack.size()) : "Bad Inventory size";
        int position = 0;
        while (position < size) {
            String name;
            Item item;
            char prefix;
            int count;
            if (this._version >= 39) {
                int itemId = this._readBuffer.getInt();
                count = this._readBuffer.getInt();
                prefix = this._readBuffer.getUnsigned();
                item = Item.of(itemId, (int)prefix);
                invStack.setStack(position, ItemStack.of(item, count));
            } else if (this._version >= 36) {
                name = this._readBuffer.getString();
                count = this._readBuffer.getInt();
                prefix = this._readBuffer.getUnsigned();
                item = Item.of(name, (int)prefix);
                invStack.setStack(position, ItemStack.of(item, count));
            } else {
                name = this._readBuffer.getString();
                count = this._readBuffer.getInt();
                prefix = '\u0000';
                item = Item.of(name, (int)prefix);
                invStack.setStack(position, item, count);
            }
            ++position;
        }
        return invStack;
    }

    private BuffList readBuffs(int size) {
        BuffList buffs = BuffList.create();
        assert (size <= buffs.size()) : "Bad BuffList size";
        int i = 0;
        while (i < 10) {
            buffs.setBuff(i, Buff.of(this._readBuffer.getInt(), this._readBuffer.getInt()));
            ++i;
        }
        return buffs;
    }

    private List<SpawnPoint> readSpawnPoints() {
        ArrayList<SpawnPoint> spawns = new ArrayList<SpawnPoint>(200);
        int i = 0;
        while (i < 200) {
            int spawnX = this._readBuffer.getInt();
            if (spawnX == -1) break;
            int spawnY = this._readBuffer.getInt();
            int worldID = this._readBuffer.getInt();
            String worldName = this._readBuffer.getString();
            spawns.add(SpawnPoint.of(worldName, spawnX, spawnY, worldID));
            ++i;
        }
        spawns.trimToSize();
        return spawns;
    }
}

