/*
 * Decompiled with CFR 0.152.
 */
package com.su.slytherin.terraria.player;

import com.su.slytherin.terraria.Razdor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class PlayerCrypt {
    private static final byte[] ENCRYPTION_KEY = "h3y_gUyZ".getBytes(Charset.forName("UTF-16LE"));

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    private PlayerCrypt() {
    }

    public static byte[] getEncryptionKey() {
        return Arrays.copyOf(ENCRYPTION_KEY, ENCRYPTION_KEY.length);
    }

    public static InputStream getCipherInput(File input) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(Razdor.requireReal(input));
        BufferedInputStream bis = new BufferedInputStream(fis);
        return new CipherInputStream(bis, PlayerCrypt.getCipher(2));
    }

    public static OutputStream getCipherOutput(File output) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(Razdor.requireReal(output));
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        return new CipherOutputStream(bos, PlayerCrypt.getCipher(1));
    }

    public static void decryptFromFileToFile(File input, File output) throws FileNotFoundException, IOException {
        InputStream is = PlayerCrypt.getCipherInput(input);
        FileOutputStream os = new FileOutputStream(output);
        int bufsize = 4096;
        byte[] buf = new byte[4096];
        try {
            int count;
            while ((count = is.read(buf)) != -1) {
                ((OutputStream)os).write(buf, 0, count);
            }
        }
        catch (Throwable throwable) {
            Razdor.close(is, os);
            throw throwable;
        }
        Razdor.close(is, os);
    }

    private static Cipher getCipher(int mode) {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS7Padding", "BC");
            cipher.init(mode, (Key)new SecretKeySpec(ENCRYPTION_KEY, "AES"), new IvParameterSpec(ENCRYPTION_KEY));
            return cipher;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to find algo.", e);
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to find padding.", e);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
            throw new RuntimeException("Key is invalid.", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
            throw new RuntimeException("IvParameterSpec is invalid.", e);
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
            throw new RuntimeException("Where's my castle??", e);
        }
    }
}

