/*
 * Decompiled with CFR 0.152.
 */
package com.su.slytherin.terraria.player;

import com.su.slytherin.terraria.Copyable;
import com.su.slytherin.terraria.Razdor;
import com.su.slytherin.terraria.player.Item;

public final class ItemStack
implements Copyable<ItemStack> {
    private final Item _item;
    private int _count;

    private ItemStack(Item item, int count) {
        this._item = Razdor.requireReal(item, "ItemStack was given null Item.");
        this._count = count;
    }

    public static ItemStack of(Item item) {
        return new ItemStack(item, 1);
    }

    public static ItemStack of(Item item, int count) {
        return new ItemStack(item, count);
    }

    public static ItemStack of(String itemName, int count) {
        return new ItemStack(Item.of(itemName, 0), count);
    }

    public int getCount() {
        return this._count;
    }

    public ItemStack setCount(int count) {
        this._count = count;
        return this;
    }

    public Item getItem() {
        return this._item;
    }

    public String getName() {
        return this._item.getItemName();
    }

    public int getNetId() {
        return this._item.getItemId();
    }

    public int getPrefix() {
        return this._item.getPrefix();
    }

    @Override
    public ItemStack copy() {
        ItemStack copy = ItemStack.of(this._item, this._count);
        assert (copy.equals(this)) : "ItemStack copy failed";
        return copy;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object == this) {
            result = true;
        } else if (object == null || object.getClass() != this.getClass()) {
            result = false;
        } else {
            ItemStack itemStack = (ItemStack)object;
            result = this._count == itemStack._count && this._item.equals(itemStack._item);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        return (31 + this._count) * 31 + this._item.hashCode();
    }

    public String toString() {
        if (this._item.equals(Item.EMPTY) && this._count == 0) {
            return "ItemStack [empty]";
        }
        return "ItemStack [item=" + this._item.getItemName() + ", count=" + this._count + "]";
    }
}

