/*
 * Decompiled with CFR 0.152.
 */
package com.su.slytherin.terraria.player;

import com.su.slytherin.terraria.ArrayIterator;
import com.su.slytherin.terraria.Copyable;
import com.su.slytherin.terraria.Razdor;
import com.su.slytherin.terraria.player.Buff;
import com.su.slytherin.terraria.player.Sizeable;
import java.util.Arrays;
import java.util.Iterator;

public final class BuffList
implements Iterable<Buff>,
Copyable<BuffList>,
Sizeable {
    private final Buff[] _buffs;
    private final int _size;

    private BuffList(int size) {
        this._size = size;
        this._buffs = new Buff[size];
        int i = 0;
        while (i < size) {
            this._buffs[i] = Buff.of(0, 0);
            ++i;
        }
    }

    private BuffList(Buff[] buffs) {
        this._buffs = buffs;
        this._size = buffs.length;
    }

    public Buff getBuff(int index) {
        return this._buffs[index].copy();
    }

    public BuffList setBuff(int index, Buff buff) {
        this._buffs[index] = Razdor.requireReal(buff).copy();
        return this;
    }

    public static BuffList create() {
        BuffList buffs = new BuffList(10);
        return buffs;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public BuffList copy() {
        Buff[] arr = new Buff[this._size];
        int i = 0;
        while (i < this._size) {
            arr[i] = this._buffs[i].copy();
            assert (arr[i] != this._buffs[i]) : "BuffList copy not copying";
            ++i;
        }
        BuffList copy = new BuffList(arr);
        assert (copy.equals(this)) : "BuffList copy failed";
        return copy;
    }

    @Override
    public Iterator<Buff> iterator() {
        return new ArrayIterator<Buff>(this.copy()._buffs);
    }

    public int hashCode() {
        int prime = 31;
        return (31 + Arrays.hashCode(this._buffs)) * 31 + this._size;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BuffList her = (BuffList)obj;
        return this._size == her._size && Arrays.equals(this._buffs, her._buffs);
    }

    public String toString() {
        return "BuffList [size=" + this._size + ", buffs=" + Arrays.toString(this._buffs) + "]";
    }
}

