/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.panel;

import com.fb.tpe.Data;
import com.fb.tpe.TerrariaPlayerEditor;
import com.fb.tpe.model.data.ItemObject;
import com.fb.tpe.model.data.ItemObjectDAO;
import com.fb.tpe.model.data.PrefixObject;
import com.fb.tpe.model.data.PrefixObjectDAO;
import com.fb.tpe.view.GUI;
import com.fb.tpe.view.dialog.EquipChooserDialog;
import com.fb.tpe.view.dialog.PrefixChooserDialog;
import com.fb.tpe.view.ui.panel.EquipPanel;
import com.fb.tpe.view.ui.panel.EquipPanelInterface;
import com.su.slytherin.terraria.player.Item;
import com.su.slytherin.terraria.player.ItemInv;
import com.su.slytherin.terraria.player.Player;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Point;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class EquipmentPanel
extends JPanel
implements EquipPanelInterface {
    private static final long serialVersionUID = -4736593120944378877L;
    private Player _player;
    private ItemInv _armor;
    private ItemInv _accessories;
    private ItemInv _social;
    private EquipPanel _equipPanel;
    JPanel panelAppearance;
    JPanel panelImage;
    JLabel imageChar;
    JLabel imageHair;
    JLabel imageHead;
    JLabel imageHand;
    JLabel imageEyes;
    JLabel imageOShi;
    JLabel imageUShi;
    JLabel imagePant;
    JLabel imageShoe;
    JPanel panelSAA;
    JPanel panelSocial;
    JPanel panelArmor;
    JPanel panelAccess;

    public EquipmentPanel() {
        this.initGUI();
    }

    public void setHair(ImageIcon icon) {
        this.imageHair.setIcon(icon);
    }

    public void setHead(ImageIcon icon) {
        this.imageHead.setIcon(icon);
    }

    public void setHand(ImageIcon icon) {
        this.imageHand.setIcon(icon);
    }

    public void setEyes(ImageIcon icon) {
        this.imageEyes.setIcon(icon);
    }

    public void setOShi(ImageIcon icon) {
        this.imageOShi.setIcon(icon);
    }

    public void setUShi(ImageIcon icon) {
        this.imageUShi.setIcon(icon);
    }

    public void setPant(ImageIcon icon) {
        this.imagePant.setIcon(icon);
    }

    public void setShoe(ImageIcon icon) {
        this.imageShoe.setIcon(icon);
    }

    public void populateFields() {
        this._player = Data.getPlayer();
        if (this._player != null) {
            ItemObject itemObject;
            int prefixId;
            Item item;
            EquipPanel equipPanel;
            int position;
            this._armor = this._player.getArmor();
            if (this._armor != null) {
                position = 0;
                while (position < 3) {
                    if (this.panelArmor.getComponent(position) instanceof EquipPanel) {
                        equipPanel = (EquipPanel)this.panelArmor.getComponent(position);
                        item = this._armor.getItem(position);
                        prefixId = item.getPrefix();
                        itemObject = ItemObjectDAO.getItemObjectById(item.getItemId());
                        EquipmentPanel.setItemPanel(equipPanel, itemObject, prefixId, 1);
                    }
                    ++position;
                }
            } else {
                JOptionPane.showMessageDialog(Data.getView(), "Unable to load armor data", "Armor Error", 0);
                TerrariaPlayerEditor.throwError();
            }
            this._accessories = this._player.getAccessories();
            if (this._accessories != null) {
                position = 0;
                while (position < 5) {
                    if (this.panelAccess.getComponent(position) instanceof EquipPanel) {
                        equipPanel = (EquipPanel)this.panelAccess.getComponent(position);
                        item = this._accessories.getItem(position);
                        prefixId = item.getPrefix();
                        itemObject = ItemObjectDAO.getItemObjectById(item.getItemId());
                        EquipmentPanel.setItemPanel(equipPanel, itemObject, prefixId, 1);
                    }
                    ++position;
                }
            } else {
                JOptionPane.showMessageDialog(Data.getView(), "Unable to load accessory data", "Accessory Error", 0);
                TerrariaPlayerEditor.throwError();
            }
            this._social = this._player.getSocial();
            if (this._social != null) {
                position = 0;
                while (position < 3) {
                    if (this.panelSocial.getComponent(position) instanceof EquipPanel) {
                        equipPanel = (EquipPanel)this.panelSocial.getComponent(position);
                        item = this._social.getItem(position);
                        prefixId = item.getPrefix();
                        itemObject = ItemObjectDAO.getItemObjectById(item.getItemId());
                        EquipmentPanel.setItemPanel(equipPanel, itemObject, prefixId, 1);
                    }
                    ++position;
                }
            } else {
                JOptionPane.showMessageDialog(Data.getView(), "Unable to load social data", "Social Error", 0);
                TerrariaPlayerEditor.throwError();
            }
        } else {
            JOptionPane.showMessageDialog(Data.getView(), "Unable to load player data", "Player Error", 0);
            TerrariaPlayerEditor.throwError();
        }
    }

    public void updatePlayer() {
        Item item;
        EquipPanel equipPanel;
        int position = 0;
        while (position < 3) {
            if (this.panelArmor.getComponent(position) instanceof EquipPanel) {
                equipPanel = (EquipPanel)this.panelArmor.getComponent(position);
                item = Item.of(equipPanel.getItemId(), equipPanel.getPrefixId());
                this._armor.setItem(position, item);
            }
            ++position;
        }
        position = 0;
        while (position < 5) {
            if (this.panelAccess.getComponent(position) instanceof EquipPanel) {
                equipPanel = (EquipPanel)this.panelAccess.getComponent(position);
                item = Item.of(equipPanel.getItemId(), equipPanel.getPrefixId());
                this._accessories.setItem(position, item);
            }
            ++position;
        }
        position = 0;
        while (position < 3) {
            if (this.panelSocial.getComponent(position) instanceof EquipPanel) {
                equipPanel = (EquipPanel)this.panelSocial.getComponent(position);
                item = Item.of(equipPanel.getItemId(), equipPanel.getPrefixId());
                this._social.setItem(position, item);
            }
            ++position;
        }
        this._player.setArmor(this._armor);
        this._player.setAccessories(this._accessories);
        this._player.setSocial(this._social);
        Data.setPlayer(this._player);
    }

    public void clearAll() {
        EquipPanel equipPanel;
        int position = 0;
        while (position < 3) {
            if (this.panelArmor.getComponent(position) instanceof EquipPanel) {
                equipPanel = (EquipPanel)this.panelArmor.getComponent(position);
                EquipmentPanel.setItemPanel(equipPanel, null, 0, 0);
            }
            ++position;
        }
        position = 0;
        while (position < 5) {
            if (this.panelAccess.getComponent(position) instanceof EquipPanel) {
                equipPanel = (EquipPanel)this.panelAccess.getComponent(position);
                EquipmentPanel.setItemPanel(equipPanel, null, 0, 0);
            }
            ++position;
        }
        position = 0;
        while (position < 3) {
            if (this.panelSocial.getComponent(position) instanceof EquipPanel) {
                equipPanel = (EquipPanel)this.panelSocial.getComponent(position);
                EquipmentPanel.setItemPanel(equipPanel, null, 0, 0);
            }
            ++position;
        }
    }

    private static void setItemPanel(EquipPanel itemPanel, ItemObject itemObject, int prefixId, int itemCount) {
        if (itemObject != null && !itemObject.equals(ItemObjectDAO.getEmptyItem())) {
            itemPanel.setItem(itemObject, prefixId);
        } else {
            itemPanel.setItem(ItemObjectDAO.getEmptyItem(), 0);
        }
    }

    @Override
    public void clickItemPanel(EquipPanel equipPanel, int itemType) {
        this._equipPanel = equipPanel;
        Point location = equipPanel.getPanelImage().getLocationOnScreen();
        location.x += equipPanel.getPanelImage().getWidth();
        location.y -= 14;
        EquipChooserDialog.equipChooserDialog(Data.getView(), this, location, itemType, equipPanel.getItemObject());
    }

    @Override
    public void chooseItemPanel(ItemObject chosenItem) {
        int itemCount = 1;
        if (chosenItem != null) {
            EquipmentPanel.setItemPanel(this._equipPanel, chosenItem, 0, itemCount);
            this.updateCharacterImage(this._equipPanel.getParent(), chosenItem);
        }
    }

    @Override
    public void clickPrefix(EquipPanel equipPanel) {
        this._equipPanel = equipPanel;
        int itemType = equipPanel.getItemObject().getItemType();
        PrefixObject prefixObject = PrefixObjectDAO.getPrefixObjectById(equipPanel.getPrefixId());
        Point location = equipPanel.getPanelImage().getLocationOnScreen();
        location.y -= 13;
        PrefixChooserDialog.prefixChooserDialog((JFrame)Data.getView(), this, location, itemType, prefixObject);
    }

    @Override
    public void choosePrefix(PrefixObject chosenPrefix) {
        ItemObject currentItem;
        int itemCount = 1;
        if (this._equipPanel != null && (currentItem = this._equipPanel.getItemObject()) != null) {
            if (Data.getUseMaxAmount()) {
                itemCount = currentItem.getItemMaxCount();
            }
            EquipmentPanel.setItemPanel(this._equipPanel, currentItem, chosenPrefix.getPrefixId(), itemCount);
        }
    }

    private void updateCharacterImage(Container parent, ItemObject newEquip) {
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.panelAppearance = new JPanel(new BorderLayout());
        this.panelAppearance.setBorder(GUI.setupAreaBorder(" Preview "));
        this.panelAppearance.setOpaque(false);
        this.panelImage = new JPanel(null);
        this.panelImage.setOpaque(false);
        this.imageHair = GUI.setupCharacterImage(this.panelImage, GUI.Icon_Hair, 0, 0);
        this.imageEyes = GUI.setupCharacterImage(this.panelImage, GUI.Icon_Eyes, 5, 9);
        this.imageHead = GUI.setupCharacterImage(this.panelImage, GUI.Icon_Head, 0, 0);
        this.imageHand = GUI.setupCharacterImage(this.panelImage, GUI.Icon_Hand, 0, 47);
        this.imageUShi = GUI.setupCharacterImage(this.panelImage, GUI.Icon_UShi, 0, 47);
        this.imageOShi = GUI.setupCharacterImage(this.panelImage, GUI.Icon_OShi, 0, 47);
        this.imageShoe = GUI.setupCharacterImage(this.panelImage, GUI.Icon_Shoe, 0, 84);
        this.imagePant = GUI.setupCharacterImage(this.panelImage, GUI.Icon_Pant, 0, 84);
        this.panelSAA = new JPanel(new GridLayout(1, 3));
        this.panelSAA.setOpaque(false);
        this.panelSocial = new JPanel(new GridLayout(5, 1));
        this.panelSocial.setBorder(GUI.setupAreaBorder("Social"));
        this.panelSocial.setOpaque(false);
        this.panelArmor = new JPanel(new GridLayout(5, 1));
        this.panelArmor.setBorder(GUI.setupAreaBorder("Armor"));
        this.panelArmor.setOpaque(false);
        this.panelAccess = new JPanel(new GridLayout(5, 1));
        this.panelAccess.setBorder(GUI.setupAreaBorder("Accessories"));
        this.panelAccess.setOpaque(false);
        this.add((Component)this.panelAppearance, "Center");
        this.panelAppearance.add(Box.createVerticalStrut(50), "North");
        this.panelAppearance.add((Component)this.panelImage, "Center");
        this.panelImage.add(this.imageHair);
        this.panelImage.add(this.imageEyes);
        this.panelImage.add(this.imageHead);
        this.panelImage.add(this.imageHand);
        this.panelImage.add(this.imageUShi);
        this.panelImage.add(this.imageOShi);
        this.panelImage.add(this.imageShoe);
        this.panelImage.add(this.imagePant);
        this.panelAppearance.add(Box.createHorizontalStrut(100), "West");
        this.panelAppearance.add((Component)new JLabel("        Equipment Overlay not implemented :("), "South");
        this.add((Component)this.panelSAA, "East");
        this.panelSAA.add(this.panelSocial);
        this.panelSocial.add(new EquipPanel(this, 4, GUI.colorEquipSocial, "Hat: "));
        this.panelSocial.add(new EquipPanel(this, 3, GUI.colorEquipSocial, "Shirt: "));
        this.panelSocial.add(new EquipPanel(this, 5, GUI.colorEquipSocial, "Pants: "));
        this.panelSAA.add(this.panelArmor);
        this.panelArmor.add(new EquipPanel(this, 4, GUI.colorEquipArmor, "Helmet: "));
        this.panelArmor.add(new EquipPanel(this, 3, GUI.colorEquipArmor, "Chest: "));
        this.panelArmor.add(new EquipPanel(this, 5, GUI.colorEquipArmor, "Greaves: "));
        this.panelSAA.add(this.panelAccess);
        int position = 0;
        while (position < 5) {
            this.panelAccess.add(new EquipPanel(this, 1, GUI.colorEquipAcces, "Access" + (position + 1) + ": "));
            ++position;
        }
    }
}

