/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.panel;

import com.fb.tpe.Data;
import com.fb.tpe.view.GUI;
import com.fb.tpe.view.ui.field.DocumentInteger;
import com.fb.tpe.view.ui.field.DocumentName;
import com.fb.tpe.view.ui.layout.SpringUtilities;
import com.fb.tpe.view.ui.panel.AppearanceSubPanel;
import com.su.slytherin.terraria.player.Player;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.Random;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CharacterPanel
extends JPanel {
    private static final long serialVersionUID = 2453993642880881789L;
    private HashMap<JTextField, Integer> _fieldLimits;
    private Player _player;
    JPanel panelInfo;
    JLabel labelName;
    JTextField editName;
    JLabel labelDifficulty;
    JComboBox comboDifficulty;
    JLabel labelGender;
    JComboBox comboGender;
    JPanel panelLifeMana;
    JPanel panelLife;
    JLabel labelLifeCur;
    JTextField editLifeCur;
    JButton buttonLifeRestore;
    JLabel labelLifeMax;
    JTextField editLifeMax;
    JButton buttonLifeSetMax;
    JPanel panelMana;
    JLabel labelManaCur;
    JTextField editManaCur;
    JButton buttonManaRestore;
    JLabel labelManaMax;
    JTextField editManaMax;
    JButton buttonManaSetMax;
    AppearanceSubPanel panelAppearance;
    DocumentListener listenerDocumentName = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent event) {
            CharacterPanel.this.updateEditNameChanged(event);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            CharacterPanel.this.updateEditNameChanged(event);
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            CharacterPanel.this.updateEditNameChanged(event);
        }
    };
    DocumentListener listenerDocumentInteger = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent event) {
            CharacterPanel.this.updateEditIntegerChanged(event);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            CharacterPanel.this.updateEditIntegerChanged(event);
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            CharacterPanel.this.updateEditIntegerChanged(event);
        }
    };
    FocusListener listenerFocusName = new FocusListener(){

        @Override
        public void focusGained(FocusEvent event) {
            CharacterPanel.this.updateEditNameValueFocus(event);
        }

        @Override
        public void focusLost(FocusEvent event) {
            CharacterPanel.this.updateEditNameValueFocus(event);
        }
    };
    FocusListener listenerFocusInteger = new FocusListener(){

        @Override
        public void focusGained(FocusEvent event) {
            CharacterPanel.this.updateEditIntegerFocus(event);
        }

        @Override
        public void focusLost(FocusEvent event) {
            CharacterPanel.this.updateEditIntegerFocus(event);
        }
    };
    ActionListener listenerComboDifficulty = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            CharacterPanel.this.clickComboDifficulty();
        }
    };
    ActionListener listenerComboGender = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            CharacterPanel.this.clickComboGender();
        }
    };
    ActionListener listenerButtonLifeRestore = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            CharacterPanel.this.clickButtonLifeRestore();
        }
    };
    ActionListener listenerButtonLifeSetMax = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            CharacterPanel.this.clickButtonLifeSetMax();
        }
    };
    ActionListener listenerButtonManaRestore = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            CharacterPanel.this.clickButtonManaRestore();
        }
    };
    ActionListener listenerButtonManaSetMax = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            CharacterPanel.this.clickButtonManaSetMax();
        }
    };

    public CharacterPanel() {
        this._fieldLimits = new HashMap();
        this.initGUI();
    }

    public AppearanceSubPanel getAppearancePanel() {
        return this.panelAppearance;
    }

    public String getCharacterName() {
        return this.editName.getText();
    }

    public void setControlsEnabled(boolean enabled) {
        this.buttonLifeRestore.setEnabled(enabled);
        this.buttonLifeSetMax.setEnabled(enabled);
        this.buttonManaRestore.setEnabled(enabled);
        this.buttonManaSetMax.setEnabled(enabled);
    }

    public void populateFields() {
        this._player = Data.getPlayer();
        if (this._player != null) {
            this.editName.setText(this._player.getName());
            this.editName.setEnabled(true);
            Data.getView().setupTitle(this._player.getName());
            this.comboDifficulty.setSelectedIndex(this._player.getDifficulty());
            this.comboDifficulty.setEnabled(true);
            boolean genderMale = this._player.isMale();
            this.comboGender.setSelectedIndex(0);
            if (!genderMale) {
                this.comboGender.setSelectedIndex(1);
            }
            this.comboGender.setEnabled(true);
            this.editLifeCur.setText(Integer.toString(this._player.getLife()));
            this.editLifeCur.setEnabled(true);
            this.editLifeMax.setText(Integer.toString(this._player.getLifeMax()));
            this.editLifeMax.setEnabled(true);
            this.editManaCur.setText(Integer.toString(this._player.getMana()));
            this.editManaCur.setEnabled(true);
            this.editManaMax.setText(Integer.toString(this._player.getManaMax()));
            this.editManaMax.setEnabled(true);
            this.panelAppearance.populateFields(this._player);
        }
    }

    public void updatePlayer() {
        this._player.setName(this.editName.getText());
        Data.getView().setupTitle(this._player.getName());
        this._player.setDifficulty(this.comboDifficulty.getSelectedIndex());
        if (this.comboGender.getSelectedIndex() == 0) {
            this._player.setMale(true);
        } else {
            this._player.setMale(false);
        }
        this._player.setLife(Integer.parseInt(this.editLifeCur.getText().trim()));
        this._player.setLifeMax(Integer.parseInt(this.editLifeMax.getText().trim()));
        this._player.setMana(Integer.parseInt(this.editManaCur.getText().trim()));
        this._player.setManaMax(Integer.parseInt(this.editManaMax.getText().trim()));
        this.panelAppearance.updatePlayer(this._player);
        Data.setPlayer(this._player);
    }

    public void randomizeCharacter() {
        Random random = new Random();
        this.comboGender.setSelectedIndex(random.nextInt(Data.GENDERS.length));
        this.panelAppearance.randomizeCharacter();
    }

    private void clickButtonLifeRestore() {
        this.editLifeCur.setText(this.editLifeMax.getText());
    }

    private void clickButtonLifeSetMax() {
        int max = 0;
        max = Data.getLimitLifeMana() ? 400 : 999;
        this.editLifeMax.setText(Integer.toString(max));
    }

    private void clickButtonManaRestore() {
        this.editManaCur.setText(this.editManaMax.getText());
    }

    private void clickButtonManaSetMax() {
        int max = 0;
        max = Data.getLimitLifeMana() ? 200 : 999;
        this.editManaMax.setText(Integer.toString(max));
    }

    private void updateEditNameChanged(DocumentEvent event) {
        Data.setCharacterDirty();
    }

    private void updateEditNameValueFocus(FocusEvent event) {
        JTextField source = (JTextField)event.getSource();
        if (event.paramString().startsWith("FOCUS_GAINED")) {
            source.selectAll();
        }
    }

    private void updateEditIntegerChanged(DocumentEvent event) {
        DocumentInteger document = (DocumentInteger)event.getDocument();
        JTextField sourceField = document.getParent();
        String strValue = sourceField.getText();
        int intValue = Data.getIntegerValue(strValue);
        int maxValue = this._fieldLimits.get(sourceField);
        if (intValue >= 0 && intValue <= maxValue) {
            sourceField.setForeground(GUI.colorEditGood);
        } else if (Data.getLimitLifeMana()) {
            sourceField.setForeground(GUI.colorEditBad);
        } else {
            sourceField.setForeground(GUI.colorEditOver);
        }
        Data.setCharacterDirty();
    }

    private void updateEditIntegerFocus(FocusEvent event) {
        JTextField sourceField = (JTextField)event.getSource();
        if (event.paramString().startsWith("FOCUS_GAINED")) {
            sourceField.selectAll();
        }
        if (event.paramString().startsWith("FOCUS_LOST")) {
            int maxValue;
            int intValue;
            String strValue = sourceField.getText();
            if (strValue.isEmpty()) {
                sourceField.setText("0");
            }
            if (Data.getLimitLifeMana() && (intValue = Data.getIntegerValue(strValue)) > (maxValue = this._fieldLimits.get(sourceField).intValue())) {
                sourceField.setText(Integer.toString(maxValue));
                Data.setCharacterDirty();
            }
        }
    }

    private void clickComboDifficulty() {
        Data.setCharacterDirty();
    }

    private void clickComboGender() {
        Data.setCharacterDirty();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.panelInfo = new JPanel(new SpringLayout());
        this.panelInfo.setBorder(GUI.setupAreaBorder("Character Info"));
        this.panelInfo.setOpaque(false);
        this.labelName = new JLabel("Name: ");
        this.labelName.setFont(GUI.fontSsP14);
        this.editName = new JTextField("PlayerName", 25);
        this.editName.setFont(GUI.fontSsB14);
        this.editName.setBackground(GUI.colorEditBack);
        this.editName.setBorder(GUI.borderEditField);
        this.editName.setForeground(GUI.colorEditGood);
        this.editName.setDocument(new DocumentName(this.editName, 20));
        this.editName.getDocument().addDocumentListener(this.listenerDocumentName);
        this.editName.setDisabledTextColor(GUI.colorDisabled);
        this.editName.setEnabled(false);
        this.editName.setToolTipText("Maximum of 20 characters");
        this.editName.addFocusListener(this.listenerFocusName);
        this.labelDifficulty = new JLabel("Difficulty: ");
        this.labelDifficulty.setFont(GUI.fontSsP14);
        this.comboDifficulty = new JComboBox<String>(Data.DIFFICULTIES);
        this.comboDifficulty.setFont(GUI.fontSsB14);
        this.comboDifficulty.setEnabled(false);
        this.comboDifficulty.addActionListener(this.listenerComboDifficulty);
        this.labelGender = new JLabel("Gender: ");
        this.comboGender = new JComboBox<String>(Data.GENDERS);
        this.comboGender.setEnabled(false);
        this.comboGender.setFont(GUI.fontSsB14);
        this.comboGender.addActionListener(this.listenerComboGender);
        this.panelLifeMana = new JPanel(new GridLayout(0, 1));
        this.panelLifeMana.setOpaque(false);
        this.panelLife = new JPanel(new GridLayout(0, 3));
        this.panelLife.setOpaque(false);
        this.panelLife.setBorder(GUI.setupAreaBorder("Life"));
        this.labelLifeCur = new JLabel("Cur. Life: ");
        this.labelLifeCur.setFont(GUI.fontSsP14);
        this.editLifeCur = this.setupIntegerEditField(400);
        this.buttonLifeRestore = new JButton("Restore");
        this.buttonLifeRestore.setEnabled(false);
        this.buttonLifeRestore.setFocusPainted(false);
        this.buttonLifeRestore.setToolTipText("Restore Cur. Life to Maximum Value");
        this.buttonLifeRestore.addActionListener(this.listenerButtonLifeRestore);
        this.labelLifeMax = new JLabel("Max Life:  ");
        this.labelLifeMax.setFont(GUI.fontSsP14);
        this.editLifeMax = this.setupIntegerEditField(400);
        this.buttonLifeSetMax = new JButton("Set Max");
        this.buttonLifeSetMax.setEnabled(false);
        this.buttonLifeSetMax.setFocusPainted(false);
        this.buttonLifeSetMax.setToolTipText("Restore Cur. Life to Maximum Value");
        this.buttonLifeSetMax.addActionListener(this.listenerButtonLifeSetMax);
        this.panelMana = new JPanel(new GridLayout(0, 3));
        this.panelMana.setOpaque(false);
        this.panelMana.setBorder(GUI.setupAreaBorder("Mana"));
        this.labelManaCur = new JLabel("Cur. Mana: ");
        this.labelManaCur.setFont(GUI.fontSsP14);
        this.editManaCur = this.setupIntegerEditField(200);
        this.buttonManaRestore = new JButton("Restore");
        this.buttonManaRestore.setEnabled(false);
        this.buttonManaRestore.setFocusPainted(false);
        this.buttonManaRestore.setToolTipText("Restore Cur. Mana to Maximum Value");
        this.buttonManaRestore.addActionListener(this.listenerButtonManaRestore);
        this.labelManaMax = new JLabel("Max Mana:  ");
        this.labelManaMax.setFont(GUI.fontSsP14);
        this.editManaMax = this.setupIntegerEditField(200);
        this.buttonManaSetMax = new JButton("Set Max");
        this.buttonManaSetMax.setEnabled(false);
        this.buttonManaSetMax.setFocusPainted(false);
        this.buttonManaSetMax.setToolTipText("Restore Cur. Mana to Maximum Value");
        this.buttonManaSetMax.addActionListener(this.listenerButtonManaSetMax);
        this.panelAppearance = new AppearanceSubPanel();
        this.add((Component)this.panelInfo, "North");
        this.panelInfo.add(this.labelName);
        this.panelInfo.add(this.editName);
        this.panelInfo.add(new JLabel(""));
        this.panelInfo.add(new JLabel(""));
        this.panelInfo.add(this.labelDifficulty);
        this.panelInfo.add(this.comboDifficulty);
        this.panelInfo.add(this.labelGender);
        this.panelInfo.add(this.comboGender);
        SpringUtilities.makeCompactGrid(this.panelInfo, 2, 4, 5, 5, 5, 5);
        this.add((Component)this.panelLifeMana, "East");
        this.panelLifeMana.add(this.panelLife);
        this.panelLife.add(this.labelLifeCur);
        this.panelLife.add(this.editLifeCur);
        this.panelLife.add(this.buttonLifeRestore);
        this.panelLife.add(this.labelLifeMax);
        this.panelLife.add(this.editLifeMax);
        this.panelLife.add(this.buttonLifeSetMax);
        this.panelLifeMana.add(this.panelMana);
        this.panelMana.add(this.labelManaCur);
        this.panelMana.add(this.editManaCur);
        this.panelMana.add(this.buttonManaRestore);
        this.panelMana.add(this.labelManaMax);
        this.panelMana.add(this.editManaMax);
        this.panelMana.add(this.buttonManaSetMax);
        this.panelLifeMana.add(Box.createVerticalGlue());
        this.panelLifeMana.add(Box.createVerticalGlue());
        this.panelLifeMana.add(Box.createVerticalGlue());
        this.add((Component)this.panelAppearance, "Center");
    }

    private JTextField setupIntegerEditField(int max) {
        JTextField result = new JTextField("0", 4);
        result.addFocusListener(this.listenerFocusInteger);
        result.setBackground(GUI.colorEditBack);
        result.setBorder(GUI.borderEditField);
        result.setDocument(new DocumentInteger(result, 3));
        result.getDocument().addDocumentListener(this.listenerDocumentInteger);
        result.setFont(GUI.fontSsB14);
        result.setHorizontalAlignment(4);
        result.setDisabledTextColor(GUI.colorDisabled);
        result.setEnabled(false);
        this._fieldLimits.put(result, max);
        return result;
    }
}

