/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.menu;

import com.fb.tpe.Data;
import com.fb.tpe.view.GUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.KeyStroke;

public class MenuSettings
extends JMenu {
    private static final long serialVersionUID = 5597671667307696872L;
    private int _mnemonic;
    JCheckBoxMenuItem menuSettingsUseMaxAmounts;
    JCheckBoxMenuItem menuSettingsLimitAmounts;
    JCheckBoxMenuItem menuSettingsLimitLifeMana;
    JCheckBoxMenuItem menuSettingsPrefixLimits;
    JCheckBoxMenuItem menuSettingsColorSelectors;
    ActionListener listenerMenuSettingsMaxAmount = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuSettings.this.eventMenuSettingsMaxAmount();
        }
    };
    ActionListener listenerMenuSettingsLimitAmounts = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuSettings.this.eventMenuSettingsLimitAmounts();
        }
    };
    ActionListener listenerMenuSettingsLimitLifeMana = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuSettings.this.eventMenuSettingsLimitLifeMana();
        }
    };
    ActionListener listenerMenuSettingsPrefixLimits = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuSettings.this.eventMenuSettingsPrefixLimits();
        }
    };
    ActionListener listenerMenuSettingsColorSelectors = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuSettings.this.eventMenuSettingsColorSelectors();
        }
    };

    public MenuSettings(String name, int mnemonic) {
        super(name);
        this._mnemonic = mnemonic;
        this.initGUI();
    }

    public void eventMenuSettingsMaxAmount() {
        Data.setUseMaxAmount(!Data.getUseMaxAmount());
    }

    public void eventMenuSettingsLimitAmounts() {
        Data.setLimitAmounts(!Data.getLimitAmounts());
    }

    public void eventMenuSettingsLimitLifeMana() {
        Data.setLimitLifeMana(!Data.getLimitLifeMana());
    }

    public void eventMenuSettingsPrefixLimits() {
        Data.setLimitPrefixes(!Data.getLimitPrefixes());
    }

    public void eventMenuSettingsColorSelectors() {
        Data.setColorSelectors(!Data.getColorSelectors());
        if (Data.getColorSelectors()) {
            Data.getView().getCharacterPanel().getAppearancePanel().showSelectors();
        } else {
            Data.getView().getCharacterPanel().getAppearancePanel().showRGB();
        }
    }

    private void initGUI() {
        this.setFont(GUI.fontSsP14);
        this.setMnemonic(this._mnemonic);
        this.menuSettingsUseMaxAmounts = this.setupMenuCBItem("Use Max Items / Times", "Use the Max Count / Time - or 999 if Limts are turned off", 85, 85, this.listenerMenuSettingsMaxAmount, true);
        this.menuSettingsLimitAmounts = this.setupMenuCBItem("Limit Max Items / Times", "Limit Items & Times to published maximums", 77, 77, this.listenerMenuSettingsLimitAmounts, true);
        this.menuSettingsLimitLifeMana = this.setupMenuCBItem("Limit Life / Mana", "Limit Life & Mana to 400 & 200", 76, 76, this.listenerMenuSettingsLimitLifeMana, true);
        this.menuSettingsPrefixLimits = this.setupMenuCBItem("Limit Prefixes for Items", "Limit Prefix Chooser to choices available in-game", 80, 80, this.listenerMenuSettingsPrefixLimits, true);
        this.menuSettingsColorSelectors = this.setupMenuCBItem("Use Color Selectors", "Use drop downs or direct RGB entry for colors", 84, 84, this.listenerMenuSettingsColorSelectors, true);
        this.add(this.menuSettingsUseMaxAmounts);
        this.add(this.menuSettingsLimitAmounts);
        this.add(this.menuSettingsLimitLifeMana);
        this.add(this.menuSettingsPrefixLimits);
        this.add(this.menuSettingsColorSelectors);
    }

    private JCheckBoxMenuItem setupMenuCBItem(String menuName, String toolTip, int mnemonic, int keyEvent, ActionListener listener, boolean selected) {
        JCheckBoxMenuItem result = new JCheckBoxMenuItem();
        result.setText(menuName);
        result.setToolTipText(toolTip);
        result.setFont(GUI.fontSsP16);
        result.setMnemonic(mnemonic);
        if (keyEvent != 0) {
            result.setAccelerator(KeyStroke.getKeyStroke(keyEvent, 2));
        }
        result.setSelected(selected);
        result.addActionListener(listener);
        return result;
    }
}

