/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.menu;

import com.fb.tpe.Data;
import com.fb.tpe.model.Model;
import com.fb.tpe.view.GUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class MenuActions
extends JMenu {
    private static final long serialVersionUID = 8275810142110131516L;
    private int _mnemonic;
    JMenuItem menuActionsClearAll;
    static JButton buttonActionsClearAll;
    JMenuItem menuActionsClearInven;
    static JButton buttonActionsClearInven;
    JMenuItem menuActionsClearBuffs;
    static JButton buttonActionsClearBuffs;
    JMenuItem menuActionsRandomize;
    static JButton buttonActionsRandomize;
    ActionListener listenerMenuActionsClearAll = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuActions.this.eventMenuActionsClearAll();
        }
    };
    ActionListener listenerMenuActionsClearInven = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuActions.this.eventMenuActionsClearInven();
        }
    };
    ActionListener listenerMenuActionsClearBuffs = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuActions.this.eventMenuActionsClearBuffs();
        }
    };
    ActionListener listenerMenuActionsRandomize = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuActions.this.eventMenuActionsRandomize();
        }
    };

    public MenuActions(String name, int mnemonic) {
        super(name);
        this._mnemonic = mnemonic;
        this.initGUI();
    }

    public static void addToolBarChoices(JToolBar toolBar) {
        toolBar.add(buttonActionsRandomize);
        toolBar.addSeparator();
        toolBar.add(buttonActionsClearAll);
        toolBar.add(buttonActionsClearInven);
        toolBar.add(buttonActionsClearBuffs);
    }

    public void setControlsEnabled(boolean enabled) {
        this.menuActionsClearAll.setEnabled(enabled);
        buttonActionsClearAll.setEnabled(enabled);
        this.menuActionsClearInven.setEnabled(enabled);
        buttonActionsClearInven.setEnabled(enabled);
        this.menuActionsClearBuffs.setEnabled(enabled);
        buttonActionsClearBuffs.setEnabled(enabled);
        this.menuActionsRandomize.setEnabled(enabled);
        buttonActionsRandomize.setEnabled(enabled);
    }

    public void eventMenuActionsClearAll() {
        int proceed = 0;
        proceed = JOptionPane.showConfirmDialog(Data.getView(), "This will clear all Inventory and Buffs!\nDo you want to continue?", "Continue?", 0);
        if (proceed == 0) {
            Data.getView().getEquipmentPanel().clearAll();
            Data.getView().getInventoryPanel().clearAll();
            Data.getView().getBankPanel().clearAll();
            Data.getView().getSafePanel().clearAll();
            Data.getView().getBuffsPanel().clearAll();
        }
    }

    public void eventMenuActionsClearInven() {
        int proceed = 0;
        proceed = JOptionPane.showConfirmDialog(Data.getView(), "This will clear all Inventory!\nDo you want to continue?", "Continue?", 0);
        if (proceed == 0) {
            Data.getView().getEquipmentPanel().clearAll();
            Data.getView().getInventoryPanel().clearAll();
            Data.getView().getBankPanel().clearAll();
            Data.getView().getSafePanel().clearAll();
        }
    }

    public void eventMenuActionsClearBuffs() {
        int proceed = 0;
        proceed = JOptionPane.showConfirmDialog(Data.getView(), "This will clear all Buffs!\nDo you want to continue?", "Continue?", 0);
        if (proceed == 0) {
            Data.getView().getBuffsPanel().clearAll();
        }
    }

    public void eventMenuActionsRandomize() {
        Data.getView().getCharacterPanel().randomizeCharacter();
    }

    private void initGUI() {
        this.setFont(GUI.fontSsP14);
        this.setMnemonic(this._mnemonic);
        this.menuActionsClearAll = this.setupMenuItem("Clear All Inventories (incl. Equip, Bank and Safe) and Buffs", "Erase All Inventories (Equip, Character, Bank, Safe) and Buffs", 65, 0, this.listenerMenuActionsClearAll, false);
        buttonActionsClearAll = this.setupMenuButton("res/images/ui/MenuActionsClearAll", "Erase All Inventories (Equip, Character, Bank, Safe) and Buffs", this.listenerMenuActionsClearAll, false);
        this.menuActionsClearInven = this.setupMenuItem("Clear Inventory (includes Equip, Bank and Safe)", "Delete Inventory contents - Equipment, Chararacter, Bank, Safe", 73, 0, this.listenerMenuActionsClearInven, false);
        buttonActionsClearInven = this.setupMenuButton("res/images/ui/MenuActionsClearInven", "Delete Inventory contents - Equipment, Chararacter, Bank, Safe", this.listenerMenuActionsClearInven, false);
        this.menuActionsClearBuffs = this.setupMenuItem("Clear Buffs", "Remove all Buffs, Debuffs, and States", 66, 0, this.listenerMenuActionsClearBuffs, false);
        buttonActionsClearBuffs = this.setupMenuButton("res/images/ui/MenuActionsClearBuffs", "Remove all Buffs, Debuffs, and States", this.listenerMenuActionsClearBuffs, false);
        this.menuActionsRandomize = this.setupMenuItem("Randomize Character Attributes", "Randomly Choose Hair, Color, and Gender", 82, 82, this.listenerMenuActionsRandomize, false);
        buttonActionsRandomize = this.setupMenuButton("res/images/ui/MenuActionsRandomize", "Randomly Choose Hair, Color, and Gender", this.listenerMenuActionsRandomize, false);
        this.add(this.menuActionsClearAll);
        this.add(this.menuActionsClearInven);
        this.add(this.menuActionsClearBuffs);
        this.add(this.menuActionsRandomize);
    }

    private JMenuItem setupMenuItem(String menuName, String toolTip, int mnemonic, int keyEvent, ActionListener listener, boolean enabled) {
        JMenuItem result = new JMenuItem();
        result.setText(menuName);
        result.setToolTipText(toolTip);
        result.setFont(GUI.fontSsP14);
        result.setMnemonic(mnemonic);
        if (keyEvent != 0) {
            result.setAccelerator(KeyStroke.getKeyStroke(keyEvent, 2));
        }
        result.setEnabled(enabled);
        result.addActionListener(listener);
        return result;
    }

    private JButton setupMenuButton(String imageName, String toolTip, ActionListener listener, boolean enabled) {
        JButton result = new JButton();
        result.setBorder(GUI.borderEmpty2px);
        result.setContentAreaFilled(false);
        result.setFocusPainted(false);
        result.setIcon(Model.loadImageIcon(String.valueOf(imageName) + ".png"));
        result.setRolloverEnabled(true);
        result.setRolloverIcon(Model.loadImageIcon(String.valueOf(imageName) + "Roll.png"));
        result.setToolTipText(toolTip);
        result.setEnabled(enabled);
        result.addActionListener(listener);
        return result;
    }
}

