/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.dialog;

import com.fb.tpe.Data;
import com.fb.tpe.model.data.PrefixObject;
import com.fb.tpe.model.data.PrefixObjectDAO;
import com.fb.tpe.view.GUI;
import com.fb.tpe.view.ui.field.PrefixCellRenderer;
import com.fb.tpe.view.ui.layout.SpringUtilities;
import com.fb.tpe.view.ui.panel.EquipPanelInterface;
import com.fb.tpe.view.ui.panel.ItemPanelInterface;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PrefixChooserDialog
extends JDialog {
    private static final long serialVersionUID = 7067074013049507003L;
    private ItemPanelInterface _parentItemPanel;
    private EquipPanelInterface _parentEquipPanel;
    private int _itemType;
    private PrefixObject _choice;
    private PrefixObject[] _prefixObjects;
    private PrefixObject _curPrefixObject;
    JPanel panelBorder;
    JPanel panelContent;
    JPanel panelControls;
    JPanel panelFilter;
    JLabel labelFilter;
    JLabel labelSpacer;
    JTextField editFilter;
    JButton buttonCancel;
    JScrollPane scrollList;
    JPanel panelList;
    PrefixCellRenderer prefixCellRenderer;
    JList listPrefixes;
    WindowFocusListener listenerWindowFocus = new WindowFocusListener(){

        @Override
        public void windowGainedFocus(WindowEvent event) {
            PrefixChooserDialog.this.requestFilterFocus();
        }

        @Override
        public void windowLostFocus(WindowEvent event) {
            PrefixChooserDialog.this.dialogLostFocus(event);
        }
    };
    ActionListener listenerButtonCancel = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            PrefixChooserDialog.this.pressCancelButton();
        }
    };
    ListSelectionListener listenerPrefixList = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent event) {
            PrefixChooserDialog.this.clickPrefixList(event);
        }
    };
    DocumentListener listenerDocumentFilter = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent event) {
            PrefixChooserDialog.this.setListData();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            PrefixChooserDialog.this.setListData();
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            PrefixChooserDialog.this.setListData();
        }
    };

    private PrefixChooserDialog(JFrame owner, ItemPanelInterface parent, Point location, int itemType, PrefixObject curPrefixObject) {
        super(owner);
        this._parentItemPanel = parent;
        this._parentEquipPanel = null;
        this.prefixChooserDialog(location, itemType, curPrefixObject);
    }

    public static void prefixChooserDialog(JFrame owner, ItemPanelInterface parent, Point location, int itemType, PrefixObject curPrefixObject) {
        PrefixChooserDialog pcd = new PrefixChooserDialog(owner, parent, location, itemType, curPrefixObject);
        pcd.setVisible(true);
    }

    private PrefixChooserDialog(JFrame owner, EquipPanelInterface parent, Point location, int itemType, PrefixObject curPrefixObject) {
        super(owner);
        this._parentItemPanel = null;
        this._parentEquipPanel = parent;
        this.prefixChooserDialog(location, itemType, curPrefixObject);
    }

    public static void prefixChooserDialog(JFrame owner, EquipPanelInterface parent, Point location, int itemType, PrefixObject curPrefixObject) {
        PrefixChooserDialog pcd = new PrefixChooserDialog(owner, parent, location, itemType, curPrefixObject);
        pcd.setVisible(true);
    }

    private void prefixChooserDialog(Point location, int itemType, PrefixObject curPrefixObject) {
        this._itemType = itemType;
        this._curPrefixObject = curPrefixObject;
        this.initGUI();
        this.populateFields();
        this.pack();
        location.x -= this.getWidth();
        this.setLocation(location);
    }

    public PrefixObject getChosenPrefix() {
        return this._choice;
    }

    private void setListData() {
        PrefixObject[] filteredPrefixes;
        ArrayList<PrefixObject> filteredList = new ArrayList<PrefixObject>();
        String filterValue = this.editFilter.getText().toLowerCase();
        if (!filterValue.isEmpty()) {
            filteredList.add(this._prefixObjects[0]);
            int index = 1;
            while (index < this._prefixObjects.length) {
                String prefixName = this._prefixObjects[index].getPrefixName().toLowerCase();
                if (prefixName.contains(filterValue)) {
                    filteredList.add(this._prefixObjects[index]);
                }
                ++index;
            }
            filteredPrefixes = new PrefixObject[filteredList.size()];
            filteredList.toArray(filteredPrefixes);
        } else {
            filteredPrefixes = this._prefixObjects;
        }
        this.listPrefixes.setListData(filteredPrefixes);
    }

    private void populateFields() {
        this.prefixCellRenderer.setCurrentObject(this._curPrefixObject);
        this._prefixObjects = PrefixObjectDAO.getFilteredPrefixes(this._itemType);
        this.listPrefixes.setListData(this._prefixObjects);
    }

    private void dialogLostFocus(WindowEvent event) {
        if (event.getOppositeWindow() != null && SwingUtilities.isDescendingFrom(event.getOppositeWindow(), this)) {
            return;
        }
        this.pressCancelButton();
    }

    private void pressCancelButton() {
        this.setVisible(false);
    }

    private void clickPrefixList(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting() && !this.listPrefixes.isSelectionEmpty()) {
            this._choice = (PrefixObject)this.listPrefixes.getSelectedValue();
            if (this._parentItemPanel != null) {
                this._parentItemPanel.choosePrefix(this._choice);
            }
            if (this._parentEquipPanel != null) {
                this._parentEquipPanel.choosePrefix(this._choice);
            }
            Data.setCharacterDirty();
            this.setVisible(false);
        }
    }

    private void registerEscapeKey() {
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PrefixChooserDialog.this.pressCancelButton();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void requestFilterFocus() {
        this.editFilter.requestFocusInWindow();
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setBackground(GUI.colorChooserBack);
        this.addWindowFocusListener(this.listenerWindowFocus);
        this.setAlwaysOnTop(true);
        this.registerEscapeKey();
        this.panelBorder = new JPanel(new SpringLayout());
        this.panelBorder.setBackground(GUI.colorChooserBack);
        this.panelContent = new JPanel(new BorderLayout());
        this.panelControls = new JPanel(new BorderLayout());
        this.panelControls.setBorder(GUI.borderEmptyLRT5px);
        this.panelControls.setBackground(GUI.colorChooserFront);
        this.panelFilter = new JPanel(new BorderLayout());
        this.labelFilter = new JLabel(" Filter: ");
        this.panelFilter.setBackground(GUI.colorChooserFront);
        this.editFilter = new JTextField("");
        this.editFilter.setBorder(GUI.borderEditField);
        this.editFilter.getDocument().addDocumentListener(this.listenerDocumentFilter);
        this.labelSpacer = new JLabel("     ");
        this.buttonCancel = new JButton("X");
        this.buttonCancel.setFocusPainted(false);
        this.buttonCancel.addActionListener(this.listenerButtonCancel);
        this.scrollList = new JScrollPane();
        this.scrollList.setVerticalScrollBarPolicy(22);
        this.scrollList.setHorizontalScrollBarPolicy(31);
        this.panelList = new JPanel(new BorderLayout());
        this.panelList.setBackground(GUI.colorChooserFront);
        this.listPrefixes = new JList();
        this.listPrefixes.setSelectionMode(0);
        this.prefixCellRenderer = new PrefixCellRenderer();
        this.listPrefixes.setCellRenderer(this.prefixCellRenderer);
        this.listPrefixes.setBackground(GUI.colorPrefixCell);
        this.listPrefixes.addListSelectionListener(this.listenerPrefixList);
        this.add(this.panelBorder);
        this.panelBorder.add((Component)this.panelContent, "Center");
        this.panelContent.add((Component)this.panelControls, "North");
        this.panelControls.add((Component)this.panelFilter, "Center");
        this.panelFilter.add((Component)this.labelFilter, "West");
        this.panelFilter.add((Component)this.editFilter, "Center");
        this.panelFilter.add((Component)this.labelSpacer, "East");
        this.panelContent.add((Component)this.panelList, "South");
        this.panelList.add((Component)this.scrollList, "Center");
        this.scrollList.getViewport().add(this.listPrefixes);
        SpringUtilities.makeCompactGrid(this.panelBorder, 1, 1, 2, 2, 2, 2);
    }
}

