/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view;

import com.fb.tpe.TerrariaPlayerEditor;
import com.fb.tpe.model.Model;
import com.fb.tpe.view.GUI;
import com.fb.tpe.view.menu.Menu;
import com.fb.tpe.view.panel.BankPanel;
import com.fb.tpe.view.panel.BuffsPanel;
import com.fb.tpe.view.panel.CharacterPanel;
import com.fb.tpe.view.panel.EquipmentPanel;
import com.fb.tpe.view.panel.InventoryPanel;
import com.fb.tpe.view.panel.SafePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class View
extends JFrame {
    private static final long serialVersionUID = 174352377814555157L;
    URL imagePath;
    Image imageApp;
    Menu menuBar;
    JTabbedPane tpContent;
    CharacterPanel characterPanel;
    EquipmentPanel equipmentPanel;
    InventoryPanel inventoryPanel;
    BankPanel bankPanel;
    SafePanel safePanel;
    BuffsPanel buffsPanel;
    ImageIcon iconCharacter;
    ImageIcon iconEquipment;
    ImageIcon iconInventory;
    ImageIcon iconBank;
    ImageIcon iconSafe;
    ImageIcon iconBuffs;

    public View() {
        super("Terraria Player Editor (v1.08)");
        UIManager.put("ToolTip.background", GUI.colorPopupBack);
        UIManager.put("ToolTip.font", GUI.fontSsP14);
        this.initGUI();
    }

    public ImageIcon getAppImage() {
        return new ImageIcon(this.imageApp);
    }

    public CharacterPanel getCharacterPanel() {
        return this.characterPanel;
    }

    public EquipmentPanel getEquipmentPanel() {
        return this.equipmentPanel;
    }

    public InventoryPanel getInventoryPanel() {
        return this.inventoryPanel;
    }

    public BankPanel getBankPanel() {
        return this.bankPanel;
    }

    public SafePanel getSafePanel() {
        return this.safePanel;
    }

    public BuffsPanel getBuffsPanel() {
        return this.buffsPanel;
    }

    public Menu getMenu() {
        return this.menuBar;
    }

    public void populateFields() {
        this.tpContent.setSelectedIndex(0);
        this.tpContent.setEnabled(true);
        this.characterPanel.populateFields();
        this.equipmentPanel.populateFields();
        this.inventoryPanel.populateFields();
        this.bankPanel.populateFields();
        this.safePanel.populateFields();
        this.buffsPanel.populateFields();
    }

    public void updatePlayer() {
        this.characterPanel.updatePlayer();
        this.equipmentPanel.updatePlayer();
        this.inventoryPanel.updatePlayer();
        this.bankPanel.updatePlayer();
        this.safePanel.updatePlayer();
        this.buffsPanel.updatePlayer();
    }

    public void setupTitle(String name) {
        String title = "Terraria Player Editor (v1.08) [" + name + "]";
        this.setTitle(title);
    }

    public void updateTitle(boolean changed) {
        String title = this.getTitle();
        if (changed) {
            if (!title.endsWith("*")) {
                this.setTitle(String.valueOf(title) + "*");
            }
        } else if (title.endsWith("*")) {
            title = title.substring(0, title.length() - 1);
            this.setTitle(title);
        }
    }

    private void initGUI() {
        this.getContentPane().setBackground(GUI.colorFrameBack);
        this.setDefaultCloseOperation(3);
        this.setLayout(new BorderLayout());
        this.setResizable(false);
        this.setBackground(GUI.colorFrameBack);
        this.imagePath = View.class.getClassLoader().getResource("res/icon/TerrariaPlayerEditor.png");
        this.imageApp = Toolkit.getDefaultToolkit().createImage(this.imagePath);
        this.setIconImage(this.imageApp);
        this.menuBar = new Menu();
        this.menuBar.setOpaque(false);
        this.tpContent = new JTabbedPane();
        this.tpContent.setBackground(GUI.colorFrameBack);
        this.tpContent.setOpaque(false);
        this.tpContent.setEnabled(false);
        this.characterPanel = new CharacterPanel();
        this.equipmentPanel = new EquipmentPanel();
        this.inventoryPanel = new InventoryPanel();
        this.bankPanel = new BankPanel();
        this.safePanel = new SafePanel();
        this.buffsPanel = new BuffsPanel();
        this.iconCharacter = Model.loadImageIcon("res/images/ui/CharacterPanel.png");
        this.iconEquipment = Model.loadImageIcon("res/images/ui/EquipmentPanel.png");
        this.iconInventory = Model.loadImageIcon("res/images/ui/InventoryPanel.png");
        this.iconBank = Model.loadImageIcon("res/images/ui/BankPanel.png");
        this.iconSafe = Model.loadImageIcon("res/images/ui/SafePanel.png");
        this.iconBuffs = Model.loadImageIcon("res/images/ui/BuffsPanel.png");
        this.setJMenuBar(this.menuBar);
        this.add((Component)this.tpContent, "Center");
        this.tpContent.addTab("Character", this.iconCharacter, this.characterPanel);
        this.tpContent.addTab("Equipment", this.iconEquipment, this.equipmentPanel);
        this.tpContent.addTab("Inventory", this.iconInventory, this.inventoryPanel);
        this.tpContent.addTab("Bank", this.iconBank, this.bankPanel);
        this.tpContent.addTab("Safe", this.iconSafe, this.safePanel);
        this.tpContent.addTab("Buffs", this.iconBuffs, this.buffsPanel);
    }

    @Override
    protected void processWindowEvent(WindowEvent event) {
        boolean proceed = true;
        if (event.getID() == 201) {
            proceed = TerrariaPlayerEditor.exitApp();
        }
        if (proceed) {
            super.processWindowEvent(event);
        }
    }
}

