/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.model.data;

import com.fb.tpe.Data;
import com.fb.tpe.model.data.ItemObject;
import com.fb.tpe.model.data.PrefixObject;
import java.util.ArrayList;
import java.util.Collections;

public class PrefixObjectDAO {
    public static final PrefixObject EMPTY_PREFIX = new PrefixObject(0, "No Prefix", 0, "No Prefix");
    private static ArrayList<PrefixObject> _prefixList;

    public static void setPrefixObjects(ArrayList<PrefixObject> prefixList) {
        _prefixList = prefixList;
    }

    public static PrefixObject[] getAllPrefixes() {
        ArrayList<PrefixObject> prefixList = new ArrayList<PrefixObject>(_prefixList);
        Collections.sort(prefixList);
        prefixList.add(0, EMPTY_PREFIX);
        PrefixObject[] result = new PrefixObject[prefixList.size()];
        prefixList.toArray(result);
        return result;
    }

    public static PrefixObject[] getFilteredPrefixes(int itemType) {
        PrefixObject[] result;
        if (Data.getLimitPrefixes()) {
            ArrayList<PrefixObject> filteredList = itemType == 1 ? PrefixObjectDAO.getAccessoryPrefixes() : PrefixObjectDAO.getCombatPrefixes(itemType);
            Collections.sort(filteredList);
            filteredList.add(0, EMPTY_PREFIX);
            result = new PrefixObject[filteredList.size()];
            filteredList.toArray(result);
        } else {
            result = PrefixObjectDAO.getPrefixObjectsByType(0, true);
        }
        return result;
    }

    public static String getPrefixName(int prefixId) {
        String result = " ";
        PrefixObject prefixObject = PrefixObjectDAO.getPrefixObjectById(prefixId);
        if (prefixObject != null) {
            result = prefixObject.getPrefixName();
        }
        return result;
    }

    public static PrefixObject getPrefixObjectById(int prefixId) {
        PrefixObject result = null;
        for (PrefixObject prefixObject : _prefixList) {
            if (prefixObject == null || prefixObject.getPrefixId() != prefixId) continue;
            result = prefixObject;
        }
        return result;
    }

    private static PrefixObject[] getPrefixObjectsByType(int type, boolean includeEmptyPrefix) {
        PrefixObject[] result;
        ArrayList<PrefixObject> prefixes = new ArrayList<PrefixObject>();
        if (type == 0) {
            result = PrefixObjectDAO.getAllPrefixes();
        } else {
            for (PrefixObject prefixObject : _prefixList) {
                if (prefixObject == null || prefixObject.getPrefixType() != type) continue;
                prefixes.add(prefixObject);
            }
            if (includeEmptyPrefix) {
                Collections.sort(prefixes);
                prefixes.add(0, EMPTY_PREFIX);
            }
            result = new PrefixObject[prefixes.size()];
            prefixes.toArray(result);
        }
        return result;
    }

    public static boolean isPrefixAllowed(ItemObject itemObject) {
        int itemId;
        boolean result = false;
        int itemType = itemObject.getItemType();
        if (itemType == 1 || itemType == 2 || itemType == 15 || itemType == 16 || itemType == 17 || itemType == 18 || itemType == 19 || itemType == 21 || itemType == 22 || itemType == 23 || itemType == 24 || itemType == 25 || itemType == 26 || itemType == 27 || itemType == 28 || itemType == 29 || itemType == 30) {
            result = true;
        }
        if ((itemId = itemObject.getItemId()) == 267 || itemId >= 562 && itemId <= 574 || itemId == 576) {
            result = false;
        }
        return result;
    }

    private static ArrayList<PrefixObject> getAccessoryPrefixes() {
        ArrayList<PrefixObject> result = new ArrayList<PrefixObject>();
        PrefixObject[] typePrefixes = PrefixObjectDAO.getPrefixObjectsByType(1, false);
        result = PrefixObjectDAO.addAll(result, typePrefixes);
        typePrefixes = PrefixObjectDAO.getPrefixObjectsByType(2, false);
        result = PrefixObjectDAO.addAll(result, typePrefixes);
        typePrefixes = PrefixObjectDAO.getPrefixObjectsByType(3, false);
        result = PrefixObjectDAO.addAll(result, typePrefixes);
        return result;
    }

    private static ArrayList<PrefixObject> getCombatPrefixes(int itemType) {
        ArrayList<PrefixObject> result = new ArrayList<PrefixObject>();
        PrefixObject[] typePrefixes = PrefixObjectDAO.getPrefixObjectsByType(2, false);
        result = PrefixObjectDAO.addAll(result, typePrefixes);
        if (itemType == 23 || itemType == 24 || itemType == 26 || itemType == 27 || itemType == 28 || itemType == 30) {
            typePrefixes = PrefixObjectDAO.getPrefixObjectsByType(3, false);
            result = PrefixObjectDAO.addAll(result, typePrefixes);
        }
        if (itemType == 15 || itemType == 18 || itemType == 19 || itemType == 21 || itemType == 28) {
            typePrefixes = PrefixObjectDAO.getPrefixObjectsByType(4, false);
            result = PrefixObjectDAO.addAll(result, typePrefixes);
        }
        if (itemType == 23 || itemType == 26) {
            typePrefixes = PrefixObjectDAO.getPrefixObjectsByType(5, false);
            result = PrefixObjectDAO.addAll(result, typePrefixes);
        }
        if (itemType == 27) {
            typePrefixes = PrefixObjectDAO.getPrefixObjectsByType(6, false);
            result = PrefixObjectDAO.addAll(result, typePrefixes);
        }
        return result;
    }

    private static ArrayList<PrefixObject> addAll(ArrayList<PrefixObject> list, PrefixObject[] objects) {
        ArrayList<PrefixObject> result = list;
        int index = 0;
        while (index < objects.length) {
            result.add(objects[index]);
            ++index;
        }
        return result;
    }
}

