/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.model.data;

import com.fb.tpe.model.data.ItemObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class ItemObjectDAO {
    private static final ItemObject EMPTY_ITEM = new ItemObject(0, "No Item", 0, 1);
    private static ArrayList<ItemObject> _itemList;

    public static ItemObject[] getAllItems() {
        ArrayList<ItemObject> itemList = new ArrayList<ItemObject>(_itemList);
        Collections.sort(itemList);
        itemList.add(0, EMPTY_ITEM);
        ItemObject[] result = new ItemObject[itemList.size()];
        itemList.toArray(result);
        return result;
    }

    public static ItemObject[] getFilteredItems(boolean[] filters) {
        ArrayList<ItemObject> filteredList = new ArrayList<ItemObject>();
        int index = 1;
        while (index < filters.length) {
            if (filters[index]) {
                ItemObject[] typeItems = ItemObjectDAO.getItemObjectsByType(index, false);
                filteredList = ItemObjectDAO.addAll(filteredList, typeItems);
            }
            ++index;
        }
        Collections.sort(filteredList);
        filteredList.add(0, EMPTY_ITEM);
        ItemObject[] result = new ItemObject[filteredList.size()];
        filteredList.toArray(result);
        return result;
    }

    public static int getItemIdByName(String itemName) {
        int result = 0;
        ItemObject itemObject = null;
        if (!itemName.equals("") && (itemObject = ItemObjectDAO.getItemObjectByName(itemName)) != null) {
            result = itemObject.getItemId();
        }
        return result;
    }

    public static String getItemNameById(int itemId) {
        String result = "";
        ItemObject itemObject = null;
        if (itemId != 0 && (itemObject = ItemObjectDAO.getItemObjectById(itemId)) != null) {
            result = itemObject.getItemName();
        }
        return result;
    }

    public static ItemObject getItemObjectById(int itemId) {
        ItemObject result = null;
        if (itemId == EMPTY_ITEM.getItemId()) {
            result = EMPTY_ITEM;
        } else {
            for (ItemObject itemObject : _itemList) {
                if (itemObject == null || itemObject.getItemId() != itemId) continue;
                result = itemObject;
            }
        }
        return result;
    }

    public static ItemObject[] getItemObjectsByType(int type, boolean includeEmptyItem) {
        ItemObject[] result;
        ArrayList<ItemObject> items = new ArrayList<ItemObject>();
        if (type == 0) {
            result = ItemObjectDAO.getAllItems();
        } else {
            for (ItemObject itemObject : _itemList) {
                if (itemObject == null || itemObject.getItemType() != type) continue;
                items.add(itemObject);
            }
            if (includeEmptyItem) {
                Collections.sort(items);
                items.add(0, EMPTY_ITEM);
            }
            result = new ItemObject[items.size()];
            items.toArray(result);
        }
        return result;
    }

    public static int getOverloadedItemType(String itemName) {
        int result = 0;
        if (itemName.equals("Iron Pickaxe")) {
            result = 1;
        } else if (itemName.equals("Iron Broadsword")) {
            result = 4;
        } else if (itemName.equals("Iron Shortsword")) {
            result = 6;
        } else if (itemName.equals("Iron Axe")) {
            result = 10;
        } else if (itemName.equals("Iron Hammer")) {
            result = 7;
        } else if (itemName.equals("Iron Bow")) {
            result = 99;
        } else if (itemName.equals("Gold Pickaxe")) {
            result = -1;
        } else if (itemName.equals("Gold Broadsword")) {
            result = -2;
        } else if (itemName.equals("Gold Shortsword")) {
            result = -3;
        } else if (itemName.equals("Gold Axe")) {
            result = -4;
        } else if (itemName.equals("Gold Hammer")) {
            result = -5;
        } else if (itemName.equals("Gold Bow")) {
            result = -6;
        } else if (itemName.equals("Silver Pickaxe")) {
            result = -7;
        } else if (itemName.equals("Silver Broadsword")) {
            result = -8;
        } else if (itemName.equals("Silver Shortsword")) {
            result = -9;
        } else if (itemName.equals("Silver Axe")) {
            result = -10;
        } else if (itemName.equals("Silver Hammer")) {
            result = -11;
        } else if (itemName.equals("Silver Bow")) {
            result = -12;
        } else if (itemName.equals("Copper Pickaxe")) {
            result = -13;
        } else if (itemName.equals("Copper Broadsword")) {
            result = -14;
        } else if (itemName.equals("Copper Shortsword")) {
            result = -15;
        } else if (itemName.equals("Copper Axe")) {
            result = -16;
        } else if (itemName.equals("Copper Hammer")) {
            result = -17;
        } else if (itemName.equals("Copper Bow")) {
            result = -18;
        } else if (itemName.equals("Blue Phaseblade")) {
            result = 198;
        } else if (itemName.equals("Red Phaseblade")) {
            result = 199;
        } else if (itemName.equals("Green Phaseblade")) {
            result = 200;
        } else if (itemName.equals("Purple Phaseblade")) {
            result = 201;
        } else if (itemName.equals("White Phaseblade")) {
            result = 202;
        } else if (itemName.equals("Yellow Phaseblade")) {
            result = 203;
        } else if (itemName.equals("Blue Phasesaber")) {
            result = -19;
        } else if (itemName.equals("Red Phasesaber")) {
            result = -20;
        } else if (itemName.equals("Green Phasesaber")) {
            result = -21;
        } else if (itemName.equals("Purple Phasesaber")) {
            result = -22;
        } else if (itemName.equals("White Phasesaber")) {
            result = -23;
        } else if (itemName.equals("Yellow Phasesaber")) {
            result = -24;
        }
        return result;
    }

    public static String getMetalSubType(String itemName) {
        String result = "";
        String[] subTypes = new String[]{"0", "Iron", "Gold", "Silver", "Copper"};
        int index = 1;
        index = 1;
        while (index < subTypes.length) {
            if (itemName.startsWith(subTypes[index])) {
                result = "." + Integer.toString(index);
            }
            ++index;
        }
        return result;
    }

    public static String getColorSubType(String itemName) {
        String result = "";
        String[] subTypes = new String[]{"0", "Phaseblade", "Phasesaber"};
        int index = 1;
        index = 1;
        while (index < subTypes.length) {
            if (itemName.startsWith(subTypes[index])) {
                result = "." + Integer.toString(index);
            }
            ++index;
        }
        return result;
    }

    public static ItemObject getEmptyItem() {
        return EMPTY_ITEM;
    }

    public static void setItemObjects(ArrayList<ItemObject> itemList) throws IOException {
        _itemList = itemList;
    }

    private static ArrayList<ItemObject> addAll(ArrayList<ItemObject> list, ItemObject[] objects) {
        ArrayList<ItemObject> result = list;
        int index = 0;
        while (index < objects.length) {
            result.add(objects[index]);
            ++index;
        }
        return result;
    }

    private static ItemObject getItemObjectByName(String itemName) {
        ItemObject result = null;
        for (ItemObject itemObject : _itemList) {
            if (itemObject == null || !itemObject.getItemName().equals(itemName)) continue;
            result = itemObject;
        }
        return result;
    }
}

