/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.model.data;

import com.fb.tpe.model.data.BuffObject;
import java.util.ArrayList;
import java.util.Collections;

public class BuffObjectDAO {
    public static final BuffObject EMPTY_BUFF = new BuffObject(0, "No Buff", 0, 0, "No Buff");
    private static ArrayList<BuffObject> _buffList;

    public static void setBuffObjects(ArrayList<BuffObject> buffList) {
        _buffList = buffList;
    }

    public static BuffObject[] getAllBuffs() {
        ArrayList<BuffObject> buffList = new ArrayList<BuffObject>(_buffList);
        Collections.sort(buffList);
        buffList.add(0, EMPTY_BUFF);
        BuffObject[] result = new BuffObject[buffList.size()];
        buffList.toArray(result);
        return result;
    }

    public static BuffObject getBuffObjectByNum(int buffNum) {
        BuffObject result = null;
        for (BuffObject buffObject : _buffList) {
            if (buffObject == null || buffObject.getBuffNum() != buffNum) continue;
            result = buffObject;
        }
        return result;
    }

    public static BuffObject getBuffObjectByName(String buffName) {
        BuffObject result = null;
        for (BuffObject buffObject : _buffList) {
            if (buffObject == null || !buffObject.getBuffName().equals(buffName)) continue;
            result = buffObject;
        }
        return result;
    }

    public static BuffObject[] getBuffObjectsByType(int type, boolean includeEmptyBuff) {
        BuffObject[] result;
        ArrayList<BuffObject> buffs = new ArrayList<BuffObject>();
        if (type == 0) {
            result = BuffObjectDAO.getAllBuffs();
        } else {
            for (BuffObject buffObject : _buffList) {
                if (buffObject == null || buffObject.getBuffType() != type) continue;
                buffs.add(buffObject);
            }
            if (includeEmptyBuff) {
                Collections.sort(buffs);
                buffs.add(0, EMPTY_BUFF);
            }
            result = new BuffObject[buffs.size()];
            buffs.toArray(result);
        }
        return result;
    }
}

