/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.model;

import au.com.bytecode.opencsv.CSVReader;
import com.fb.tpe.Data;
import com.fb.tpe.TerrariaPlayerEditor;
import com.fb.tpe.model.BadDataTypeException;
import com.fb.tpe.model.data.BuffObject;
import com.fb.tpe.model.data.BuffObjectDAO;
import com.fb.tpe.model.data.BuffTypes;
import com.fb.tpe.model.data.HairObject;
import com.fb.tpe.model.data.HairObjectDAO;
import com.fb.tpe.model.data.ItemObject;
import com.fb.tpe.model.data.ItemObjectDAO;
import com.fb.tpe.model.data.ItemTypes;
import com.fb.tpe.model.data.PrefixObject;
import com.fb.tpe.model.data.PrefixObjectDAO;
import com.fb.tpe.model.data.PrefixTypes;
import com.fb.tpe.view.GUI;
import com.fb.tpe.view.Splash;
import com.su.slytherin.terraria.player.ParseException;
import com.su.slytherin.terraria.player.PlayerIO;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public final class Model {
    public Model() {
        try {
            ItemObjectDAO.setItemObjects(this.loadItemObjects("res/text/ItemList.csv"));
            PrefixObjectDAO.setPrefixObjects(this.loadPrefixObjects("res/text/PrefixList.csv"));
            BuffObjectDAO.setBuffObjects(this.loadBuffObjects("res/text/BuffList.csv"));
            HairObjectDAO.setHairObjects(this.loadHairObjects());
            Data.setCharacterColorChoices(this.setupCharacterColorChoices());
            this.loadCharacterImages();
        }
        catch (IOException error) {
            JOptionPane.showMessageDialog(Data.getView(), "I/O Error: " + error.getMessage(), "I/O Error: Terraria Player Editor (v1.08)", 0);
            TerrariaPlayerEditor.throwError();
        }
        catch (BadDataTypeException error) {
            JOptionPane.showMessageDialog(Data.getView(), "Bad Data Type Error: " + error.getMessage(), "Bad Data Type Error: Terraria Player Editor (v1.08)", 0);
            TerrariaPlayerEditor.throwError();
        }
    }

    /*
     * Unable to fully structure code
     */
    private ArrayList<ItemObject> loadItemObjects(String sourceFile) throws IOException, BadDataTypeException {
        result = new ArrayList<ItemObject>();
        reader = null;
        name = "";
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(sourceFile);
            reader = new CSVReader((Reader)new BufferedReader(new InputStreamReader(stream)));
            if (true) ** GOTO lbl22
        }
        catch (NullPointerException notUsed) {
            throw new IOException("Unable to open file: " + sourceFile);
        }
        do {
            if (!line[0].startsWith("#") && line[0].trim().length() > 0) {
                if (line.length == 4) {
                    num = Data.getIntegerValue(line[0].trim());
                    name = line[1].trim();
                    type = ItemTypes.getItemType(line[2].trim());
                    coun = Data.getIntegerValue(line[3].trim());
                    result.add(new ItemObject(num, name, type, coun));
                } else {
                    throw new BadDataTypeException("! Invalid data line: (" + sourceFile + "):\n" + line[1]);
                }
            }
            Splash.updateSplashProgress(1);
lbl22:
            // 2 sources

        } while ((line = reader.readNext()) != null);
        if (reader != null) {
            reader.close();
        }
        if (stream != null) {
            stream.close();
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private ArrayList<PrefixObject> loadPrefixObjects(String sourceFile) throws IOException, BadDataTypeException {
        result = new ArrayList<PrefixObject>();
        reader = null;
        name = "";
        tip = "";
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(sourceFile);
            reader = new CSVReader((Reader)new BufferedReader(new InputStreamReader(stream)));
            if (true) ** GOTO lbl23
        }
        catch (NullPointerException notUsed) {
            throw new IOException("Unable to open file: " + sourceFile);
        }
        do {
            if (!line[0].startsWith("#") && line[0].trim().length() > 0) {
                if (line.length == 4) {
                    num = Data.getIntegerValue(line[0].trim());
                    name = line[1].trim();
                    type = PrefixTypes.getPrefixType(line[2].trim());
                    tip = line[3].trim();
                    result.add(new PrefixObject(num, name, type, tip));
                } else {
                    throw new BadDataTypeException("! Invalid data line: (" + sourceFile + "):\n" + line[1]);
                }
            }
            Splash.updateSplashProgress(1);
lbl23:
            // 2 sources

        } while ((line = reader.readNext()) != null);
        if (reader != null) {
            reader.close();
        }
        if (stream != null) {
            stream.close();
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private ArrayList<BuffObject> loadBuffObjects(String sourceFile) throws IOException, BadDataTypeException {
        result = new ArrayList<BuffObject>();
        reader = null;
        name = "";
        tip = "";
        try {
            stream = this.getClass().getClassLoader().getResourceAsStream(sourceFile);
            reader = new CSVReader((Reader)new BufferedReader(new InputStreamReader(stream)));
            if (true) ** GOTO lbl24
        }
        catch (NullPointerException notUsed) {
            throw new IOException("Unable to open file: " + sourceFile);
        }
        do {
            if (!line[0].startsWith("#") && line[0].trim().length() > 0) {
                if (line.length == 5) {
                    num = Data.getIntegerValue(line[0].trim());
                    name = line[1].trim();
                    type = BuffTypes.getBuffType(line[2].trim());
                    time = Data.getIntegerValue(line[3].trim());
                    tip = line[4].trim();
                    result.add(new BuffObject(num, name, type, time, tip));
                } else {
                    throw new BadDataTypeException("! Invalid data line: (" + sourceFile + "):\n" + line[1]);
                }
            }
            Splash.updateSplashProgress(1);
lbl24:
            // 2 sources

        } while ((line = reader.readNext()) != null);
        if (reader != null) {
            reader.close();
        }
        if (stream != null) {
            stream.close();
        }
        return result;
    }

    private ArrayList<HairObject> loadHairObjects() {
        ArrayList<HairObject> result = new ArrayList<HairObject>();
        int num = 1;
        while (num <= 32) {
            result.add(new HairObject(num));
            ++num;
        }
        Splash.updateSplashProgress(50);
        return result;
    }

    private Color[] setupCharacterColorChoices() {
        ArrayList<Color> listColors = new ArrayList<Color>();
        int[] nArray = new int[5];
        nArray[1] = 64;
        nArray[2] = 128;
        nArray[3] = 192;
        nArray[4] = 255;
        int[] values = nArray;
        int red = 0;
        while (red < values.length) {
            int green = 0;
            while (green < values.length) {
                int blue = 0;
                while (blue < values.length) {
                    Color color = new Color(values[red], values[green], values[blue]);
                    listColors.add(color);
                    ++blue;
                }
                ++green;
            }
            ++red;
        }
        Color[] result = new Color[listColors.size()];
        listColors.toArray(result);
        Splash.updateSplashProgress(50);
        return result;
    }

    private void loadCharacterImages() {
        GUI.Icon_Hair = Model.loadImageIcon("res/images/char/Hair.png");
        GUI.Icon_Head = Model.loadImageIcon("res/images/char/Head.png");
        GUI.Icon_Hand = Model.loadImageIcon("res/images/char/Hands.png");
        GUI.Icon_Eyes = Model.loadImageIcon("res/images/char/Eyes.png");
        GUI.Icon_OShi = Model.loadImageIcon("res/images/char/Shirt.png");
        GUI.Icon_UShi = Model.loadImageIcon("res/images/char/Undershirt.png");
        GUI.Icon_Pant = Model.loadImageIcon("res/images/char/Pants.png");
        GUI.Icon_Shoe = Model.loadImageIcon("res/images/char/Shoes.png");
        Splash.updateSplashProgress(50);
    }

    public static ImageIcon loadImageIcon(String imageFile) {
        ImageIcon result = null;
        try {
            InputStream stream = Model.class.getClassLoader().getResourceAsStream(imageFile);
            result = new ImageIcon(ImageIO.read(stream));
        }
        catch (IllegalArgumentException error) {
            JOptionPane.showMessageDialog(Data.getView(), "Image Load Error: " + imageFile + "\n" + error.getMessage(), "Image Load Error: Terraria Player Editor (v1.08)", 0);
            TerrariaPlayerEditor.throwError();
        }
        catch (IOException error) {
            JOptionPane.showMessageDialog(Data.getView(), "Image Load Error: " + error.getMessage(), "Image Load Error: Terraria Player Editor (v1.08)", 0);
            TerrariaPlayerEditor.throwError();
        }
        catch (NullPointerException error) {
            JOptionPane.showMessageDialog(Data.getView(), "Image Load Error: " + error.getMessage(), "Image Load Error: Terraria Player Editor (v1.08)", 0);
            TerrariaPlayerEditor.throwError();
        }
        return result;
    }

    public void loadPlayer(File playerFile) throws IOException, ParseException {
        Data.setPlayer(PlayerIO.loadPlayer(playerFile));
    }

    public void savePlayer() throws IOException {
        PlayerIO.writePlayer(Data.getPlayerFile(), Data.getPlayer());
    }

    public void backupFile(File sourceFile) throws IOException {
        if (sourceFile.exists()) {
            String targetFileName = String.valueOf(sourceFile.getAbsolutePath()) + ".tpe";
            File targetFile = new File(targetFileName);
            if (!targetFile.exists()) {
                targetFile.createNewFile();
            }
            FileChannel source = null;
            AbstractInterruptibleChannel target = null;
            try {
                source = new FileInputStream(sourceFile).getChannel();
                target = new FileOutputStream(targetFile).getChannel();
                ((FileChannel)target).transferFrom(source, 0L, source.size());
            }
            finally {
                if (source != null) {
                    source.close();
                }
                if (target != null) {
                    target.close();
                }
            }
        }
    }
}

